CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
-- public.rc_vd_conv definition

-- Drop table

-- DROP TABLE public.rc_vd_conv;
IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_vd_conv') THEN 

CREATE TABLE public.rc_vd_conv (
	cd_emp numeric NOT NULL DEFAULT 0,
	cd_ctr numeric NOT NULL DEFAULT 0,
	cd_filial numeric NOT NULL DEFAULT 0,
	cd_cx numeric NOT NULL DEFAULT 0,
	nr_ecf numeric NOT NULL DEFAULT 0,
	cd_cli numeric NOT NULL DEFAULT 0,
	dt_vd timestamp NOT NULL,
	dt_fecha timestamp NULL,
	vlr_conv numeric(14, 4) NOT NULL DEFAULT 0,
	st_fechvd_conv int4 NOT NULL DEFAULT 0,
	cd_usu numeric NOT NULL DEFAULT 0,
	dt_cad timestamp NOT NULL,
	dt_atual timestamp NULL,
	tp_lanc numeric NOT NULL DEFAULT 0,
	nr_autorizacao varchar(50) NOT NULL DEFAULT ''::character varying,
	parc numeric NOT NULL DEFAULT 1,
	tp_cancel numeric NULL DEFAULT 0,
	cd_conv numeric NULL DEFAULT 0,
	hr_vd timestamp NULL,
	dt_glosa timestamp NULL,
	dt_cad_audit timestamp NULL DEFAULT now(),
	flag_conv_afastado numeric NULL DEFAULT 0,
	orig_cons numeric NULL DEFAULT 0,
	qtd_dias_prorrog numeric NULL,
	aplicacao varchar(20) NULL,
	nr_ecf_uuid varchar(256) NULL,
	tp_vd_api numeric NULL DEFAULT 0,
	nr_cartao_api varchar(20) NULL DEFAULT ''::character varying,
	CONSTRAINT ix_rc_vd_conv UNIQUE (cd_emp, cd_filial, cd_cx, dt_vd, nr_ecf, parc),
	CONSTRAINT pk_rc_vd_conv PRIMARY KEY (cd_emp, cd_ctr)
);

END IF; 

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();




